*******************************************************************************
*                        680xx Grundprogramm ansehen                          *
*                         (C) 1990 Ralph Dombrowski                           *
*                             2008 Jens Mewes                                 *
*                                 Rev 7.10                                    *
*                                01.01.2008                                   *
*                       Menpunkt Speicher ansehen                            *
*******************************************************************************


speicheraus:                    * Speicher ansehen
 lea spmsg1(pc),a0
 bsr headaclr                   * berschrift ausgeben
 eori.b #1,wrtpage(a5)
 bsr aktpage                    * Andere Seite
 bsr headaus                    * Auch dort ausgeben
speich1:
 move.b viewpage(a5),wrtpage(a5)* Leseseite = Schreibseite
 bsr aktpage
 bsr.s getadr                   * Adresse lesen
 bcs carset                     * Fehler
 bsr spdump                     * Dump ausgeben
speich2:
 bsr ki                         * Zeichen von Tastatur holen
 cmp.b #$1b,d0                  * <ESC> = Ende
 beq carset
 cmp.b #'M',d0                  * 'M' ist Ende
 beq carset
 cmp.b #'R',d0                  * 'R' = neue Adresse
 bne.s speich3
 bsr marke0                     * Alte Marke lschen
bra.s speich1                   * Ausgeben
speich3:
 bsr.s speich4                  * Auswertung Rest
bra.s speich2                   * Wiederholen

speich4:
 cmp.b #'+',d0                  * Halbe Seite vor
 bne.s speich5
 bsr marke0                     * Alte Marke weg
 adda #$40,a3                   * Neue Adresse
bra spdump1                     * Dump ausgeben
speich5:
 cmp.b #'-',d0                  * Halbe Seite zurck
 bne.s speich6
 bsr marke0                     * Alte Marke weg
 suba #$40,a3                   * Neue Adresse
bra spdump1                     * Dump ausgeben
speich6:
 cmp.b #'S',d0                  * Suchen
 bne.s speich7
 bsr marke1                     * Alte Marke weg
 bsr suchwert                   * Wert suchen
 move.l a4,d0                   * Neue Adresse, wenn gefunden
bra spdump                      * Dump ausgeben
speich7:
 cmp.b #'F',d0                  * Speicher fllen
 bne.s speich8
 bsr marke1                     * Alte Marke weg
 bsr fillspei                   * Speicher fllen
 move.l a4,d0                   * Neue Adresse
bra spdump                      * Dump ausgeben
speich8:
 cmp.b #'1',d0
 bne.s speich9                  * Ein Byte neu eingeben
 bsr spadr                      * Adresse holen und Wert berechnen
 bcs.s speich8a                 * Fehler = Ende
 bsr spdump                     * Dump, da neue Adresse
 moveq #0,d7                    * Bearbeitung mit Textein (1 mit Readaus)
 bsr.s speich8b                 * Marke eingeben
speich8a:
 move.l a4,d0                   * Neue Adresse
bra spdump                      * Dump neu

speich8b:                       * Ein Byte neu oder ndern (d7 = Typ)
 bsr marke1                     * Marke lschen
 addq #6,d1                     * d1 = X-Position Byte
 lea einbuf(a5),a0
 move.b #'$',(a0)+              * Eingabe als Hexadezimalwert
 move.b (a4),d0                 * Alten Wert
 bsr print2x                    * holen und ablegen
 subq.l #2,a0                   * Alte Adresse
 moveq #$11,d0                  * Gre
 tst d7
 bne.s speich8c
 moveq #3,d3                    * Neu eingeben, deshalb textein
 bsr textein
bra.s speich8d                  * Weiter
speich8c:
 moveq #0,d3                    * ndern, deshalb readaus
 bsr readaus
speich8d:
 add #12,d1                     * Position drittes Zeichen
 bsr moveto                     * Positionieren
 bsr erapen                     * Auf Lschen
 move.b #10,(a6)                * Eventuell vorhandenes drittes Zeichen lschen
 lea einbuf+1(a5),a0
 cmp.b #$27,(a0)                * Wenn ', dann ASCII-Zeichen Eingabe
 beq.s speich8e
 subq.l #1,a0                   * sonst mit '$'
speich8e:
 bsr wertmfeh                   * Wert mit Fehleranalyse
 bcs.s speich8f                 * Fehler
 move.b d0,(a4)                 * Sonst abspeichern
speich8f:
 addq.l #1,a4                   * Neue Adresse
rts

speich9:
 cmp #'2',d0
 bne.s speich10                 * Byte ndern
 bsr.s spadr                    * Adresse holen
 bcs.s speich8a                 * Fehler
 bsr spdump                     * Dump, da neue Adresse
 moveq #1,d7                    * Flag fr ndern
 bsr.s speich8b                 * Byte ndern
bra.s speich8a                  * Ende mit Adressneueinstellung

speich10:
 cmp.b #'3',d0
 bne.s speich11                 * 16 Bytes neu eingeben
 bsr.s spadr                    * Adresse holen
 bcs.s speich8a                 * Fehler
 moveq #0,d7                    * Merker fr eingeben
spei10a:
 and.b #$f0,d0                  * Adresse mu auf 16 Byte-Adresse liegen
 moveq #16-1,d1                 * 16 Bytes eingeben
spei10b:
 movem.l d0/d1/d7,-(a7)
 move d7,-(a7)                  * d7 merken
 bsr spdump                     * Dump ausgeben
 move (a7)+,d7                  * d7 zurck
 bsr speich8b                   * Byte neu eingeben
 movem.l (a7)+,d0/d1/d7
 addq.l #1,d0                   * Nchste Adresse
dbra d1,spei10b
bra spdump                      * Am Ende nochmals Dump

speich11:
 cmp.b #'4',d0
 bne carset                     * 16 Bytes ndern
 bsr.s spadr                    * Adresse holen
 bcs speich8a                   * Fehler
 moveq #1,d7                    * Merker fr ndern
bra.s spei10a                   * Ausfhren

spadr:
 bsr.s marke1                   * Marke lschen
 bsr getadr                     * Adresse holen
 bcc carres                     * OK, alles klar
 lea einbuf(a5),a0
 bsr igbn                       * Leerzeichen ignorieren
 cmp.b #'=',(a0)+
 bne carset                     * Kein '=', dann Fehler
 bsr igbn                       * Leerzeichen ignorieren
 tst.b (a0)                     * Null mu danach kommen
 bne carset
 move.l a4,d0                   * '=' bedeutet alte Adresse
bra carres

marke0:
 bsr.s marke1                   * Marke weg
 eori.b #1,wrtpage(a5)          * Neue Schreibseite
bra aktpage                     * Und umschalten

marke1:
 bsr erapen                     * Auf Lschen
marke:
 move.l a4,d1                   * Adresse
 sub.l a3,d1                    * Seitenanfangsadresse
 bmi carset                     * Negativ, dann keine Marke vorhanden
 cmp.l #16*8,d1
 bpl carset                     * Auch nicht vorhanden
 move d1,d2
 lsr #4,d2                      * Durch 16, wegen Zeile (16 Byte pro Zeile)
 muls #-20,d2                   * Hhe berechnen
 add #160,d2                    * Hier oberste Zeile
 and #$f,d1                     * Berechnung X-Position
 mulu #24,d1                    * Abstand zwischen zwei Bytes
 add #54,d1                     * Anfangs X-Position
 bsr moveto                     * Positionieren
 move.b #'>',(a6)               * Marke ausgeben
rts

spdump:                         * Dump durchfhren
 movea.l d0,a4                  * d0 = Anfangsadresse
 and.b #$f0,d0                  * Zeilenanfangsadresse
 movea.l d0,a3                  * Merken
 lea spmsg2(pc),a0
 moveq #$22,d0
 moveq #20,d1
 move #190,d2
 bsr textaus                    * berschrift
 lea spmsg3(pc),a0
 moveq #$21,d0
 moveq #0,d1
 move #175,d2
 bsr textprint                  * Byte-Einteilung
 eori.b #1,wrtpage(a5)
 bsr aktpage                    * Das gleiche auch auf Seite 1
 moveq #$21,d0
 bsr textprint
 lea spmsg2(pc),a0
 moveq #$22,d0
 moveq #20,d1
 move #190,d2
 bsr textaus
spdump1:
 bsr wait                       * Hier beginnt Dump
 lea gdp.w,a6                   * GDP-Basis-Register
 lea gdp+9*cpu.w,a2             * X-Register (Low Byte)
 moveq #2,d7                    * WAIT-Bit
 clr.b gdp+$a*cpu.w             * X-Koordinate einstellen
 move.b #160,gdp+$b*cpu.w
 move.b #$11,gdp+3*cpu.w        * Schriftgre einstellen
 bsr erapen                     * Auf Lschen
 moveq #8-1,d5                  * 8 Reihen
spdump2:
 btst.b d7,(a6)                 * Ohne Sprung zu wait schneller
 beq.s spdump2
 move.b #$d,(a6)                * Anfangs X-Position
 moveq #10,d0
 bsr clr8                       * 8 Zeichen lschen
 add.b #12,(a2)                 * 2 Zeichen Platz lassen
 moveq #16-1,d4                 * 16 Zeichen
spdump3:
 btst.b d7,(a6)
 beq.s spdump3
 move.b d0,(a6)                 * 2 Zeichen lschen
spdump3a:
 btst.b d7,(a6)
 beq.s spdump3a
 move.b d0,(a6)
spdump3b:
 btst.b d7,(a6)                 * Ohne Sprung zu wait schneller
 beq.s spdump3b
 add.b #12,(a2)                 * 2 Zeichen Platz lassen
dbra d4,spdump3
 bsr clr8                       * Wieder 8 Zeichen lschen
 move.b #$d,(a6)                * X-Anfangsposition
 sub.b #10,gdp+$b*cpu.w         * Eine Zeile runter
 bsr clr8                       * 8 Zeichen lschen
 add.b #12,(a2)                 * 2 Zeichen frei
 moveq #16-1,d4                 * 16 Zeichen
spdump4:
 btst.b d7,(a6)
 beq.s spdump4
 move.b d0,(a6)                 * Lschen
spdump4a:
 btst.b d7,(a6)                 * Ohne Sprung zu wait schneller
 beq.s spdump4a
 add.b #18,(a2)                 * 3 Zeichen frei
dbra d4,spdump4
 bsr clr8                       * Dann wieder 8 lschen
 sub.b #10,gdp+$b*cpu.w         * Eine Zeile tiefer
dbra d5,spdump2
 bsr setpen                     * Auf Schreiben
 move.b #160,gdp+$b*cpu.w       * Oberste Zeile
 lea prttab(pc),a1              * Zeichen fr HEX-ASCII-Umwandlung
 moveq #8-1,d5                  * 8 Zeilen
spdump5:
 move.b #$d,(a6)                * X - Anfang
 move.l a3,d0                   * Zeilenanfangsadresse
 bsr set8                       * ausgeben
 moveq #0,d0                    * Fr Prfsummenbildung
 moveq #0,d3                    * Ebenfalls
 moveq #16-1,d4
spdump6:
 move.b (a3)+,d3                * Wert holen
 add.l d3,d0                    * Prfsumme bilden
 move.b d3,d2
 lsr #4,d2
 and #$f,d2                     * Vorderen vier Bits
spdump6a:
 btst.b d7,(a6)                 * Ohne Sprung zu wait schenller
 beq.s spdump6a
 add.b #12,(a2)                 * 2 Zeichen Platz lassen
 move.b 0(a1,d2),(a6)           * Bits als Ascii-Zeichen ausgeben
 and #$f,d3                     * Restlichen vier Bits
spdump6b:
 btst.b d7,(a6)                 * Ohne Sprung schneller
 beq.s spdump6b
 move.b 0(a1,d3),(a6)           * Jetzt ausgeben
dbra d4,spdump6
 move.l d0,d6                   * Prfsumme merken
spdump7:
 btst.b d7,(a6)                 * Ohne Sprung schneller
 beq.s spdump7
 add.b #12,(a2)                 * 2 Zeichen Platz
 bsr.s set8                     * 8 Zeichen ausgeben
 sub.b #10,gdp+$b*cpu.w         * Eine Zeile runter
 move.b #$d,(a6)                * X auf Null fr nchste Zeile
 suba #16,a3                    * a3 auf letzten Wert
 move.l a3,d0
 bsr.s set8                     * 8 Zeichen ausgeben (Adresse)
 add.b #12,(a2)                 * 2 Zeichen frei
 moveq #16-1,d4
spdump8:
 move.b (a3)+,d0                * Zeichen holen
 bsr putascii                   * In Ascii wandeln
 bsr cmdput                     * Und ausgeben mit Sonderzeichen
spdump9:
 btst.b d7,(a6)
 beq.s spdump9                  * Ohne Sprung zu wait schneller
 add.b #18,(a2)                 * 3 Zeichen frei
dbra d4,spdump8
 move.l d6,d0                   * Prfsumme holen
 bsr.s set8                     * 8 Zeichen ausgeben
 sub.b #10,gdp+$b*cpu.w         * Eine Zeile runter
dbra d5,spdump5
 suba.l #16*8,a3                * Anfangsadresse Seite
 bsr marke                      * Marke setzen
 move.b wrtpage(a5),viewpage(a5)
bra aktpage                     * Seite sichtbar machen

set8:                           * 8 Zeichen ausgeben
 moveq #8-1,d3
set8a:
 rol.l #4,d0
 move.b d0,d2
 and #$f,d2                     * Nur 4 Bits
set8b:
 btst.b d7,(a6)
 beq.s set8b                    * Ohne Sprung zu wait schneller
 move.b 0(a1,d2),(a6)           * 4 Bits in ASCII ausgeben
dbra d3,set8a
set8c:
 btst.b d7,(a6)                 * Ohne Sprung zu wait schneller
 beq.s set8c
rts

clr8:                           * 8 Zeichen lschen
 moveq #8-1,d3                  * In d0 steht Zeichen zum Lschen
clr8a:
 btst.b d7,(a6)
 beq.s clr8a
 move.b d0,(a6)                 * Zeichen an GDP
dbra d3,clr8a
clr8b:
 btst.b d7,(a6)                 * Ohne Sprung zu wair schneller
 beq.s clr8b
rts

headaclr:                       * berschrift ausgeben (a0=Adresse)
 bsr clrall                     * Screen lschen
headaus:                        * Ohne Lschen
 moveq #$33,d0                  * Gre
 move #225,d2                   * Y-Position
bra centertxt                   * Mittig positionieren und ausgeben

                                                                                                                                                                                                                     